/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LongBlockPos;

public class Helper {
    public static final Logger logger = LogManager.getLogger((String)"Portal");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();

    public static double getCollidingT(Vec3 planeCenter, Vec3 planeNormal, Vec3 lineOrigin, Vec3 lineDirection) {
        return planeCenter.m_82546_(lineOrigin).m_82526_(planeNormal) / lineDirection.m_82526_(planeNormal);
    }

    public static boolean isInFrontOfPlane(Vec3 pos, Vec3 planePos, Vec3 planeNormal) {
        return pos.m_82546_(planePos).m_82526_(planeNormal) > 0.0;
    }

    public static Vec3 fallPointOntoPlane(Vec3 point, Vec3 planePos, Vec3 planeNormal) {
        double t = Helper.getCollidingT(planePos, planeNormal, point, planeNormal);
        return point.m_82549_(planeNormal.m_82490_(t));
    }

    public static Vec3i getUnitFromAxis(Direction.Axis axis) {
        return Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_();
    }

    public static int getCoordinate(Vec3i v, Direction.Axis axis) {
        return axis.m_7863_(v.m_123341_(), v.m_123342_(), v.m_123343_());
    }

    public static double getCoordinate(Vec3 v, Direction.Axis axis) {
        return axis.m_6150_(v.f_82479_, v.f_82480_, v.f_82481_);
    }

    public static int getCoordinate(Vec3i v, Direction direction) {
        return Helper.getCoordinate(v, direction.m_122434_()) * (direction.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
    }

    public static Vec3 putCoordinate(Vec3 v, Direction.Axis axis, double value) {
        return switch (axis) {
            case Direction.Axis.X -> new Vec3(value, v.f_82480_, v.f_82481_);
            case Direction.Axis.Y -> new Vec3(v.f_82479_, value, v.f_82481_);
            default -> new Vec3(v.f_82479_, v.f_82480_, value);
        };
    }

    public static BlockPos putCoordinate(Vec3i v, Direction.Axis axis, int value) {
        return switch (axis) {
            case Direction.Axis.X -> new BlockPos(value, v.m_123342_(), v.m_123343_());
            case Direction.Axis.Y -> new BlockPos(v.m_123341_(), value, v.m_123343_());
            default -> new BlockPos(v.m_123341_(), v.m_123342_(), value);
        };
    }

    public static Vec3 putSignedCoordinate(Vec3 vec, Direction direction, double value) {
        return switch (direction) {
            case Direction.DOWN -> new Vec3(vec.f_82479_, -value, vec.f_82481_);
            case Direction.UP -> new Vec3(vec.f_82479_, value, vec.f_82481_);
            case Direction.NORTH -> new Vec3(vec.f_82479_, vec.f_82480_, -value);
            case Direction.SOUTH -> new Vec3(vec.f_82479_, vec.f_82480_, value);
            case Direction.WEST -> new Vec3(-value, vec.f_82480_, vec.f_82481_);
            case Direction.EAST -> new Vec3(value, vec.f_82480_, vec.f_82481_);
            default -> throw new RuntimeException();
        };
    }

    public static double getSignedCoordinate(Vec3 vec, Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> -vec.f_82480_;
            case Direction.UP -> vec.f_82480_;
            case Direction.NORTH -> -vec.f_82481_;
            case Direction.SOUTH -> vec.f_82481_;
            case Direction.WEST -> -vec.f_82479_;
            case Direction.EAST -> vec.f_82479_;
            default -> throw new RuntimeException();
        };
    }

    public static double getDistanceSqrOnAxisPlane(Vec3 vec, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> vec.f_82480_ * vec.f_82480_ + vec.f_82481_ * vec.f_82481_;
            case Direction.Axis.Y -> vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
            case Direction.Axis.Z -> vec.f_82479_ * vec.f_82479_ + vec.f_82480_ * vec.f_82480_;
        };
    }

    public static double getBoxCoordinate(AABB box, Direction direction) {
        switch (direction) {
            case DOWN: {
                return box.f_82289_;
            }
            case UP: {
                return box.f_82292_;
            }
            case NORTH: {
                return box.f_82290_;
            }
            case SOUTH: {
                return box.f_82293_;
            }
            case WEST: {
                return box.f_82288_;
            }
            case EAST: {
                return box.f_82291_;
            }
        }
        throw new RuntimeException();
    }

    public static AABB replaceBoxCoordinate(AABB box, Direction direction, double coordinate) {
        switch (direction) {
            case DOWN: {
                return new AABB(box.f_82288_, coordinate, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
            }
            case UP: {
                return new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, coordinate, box.f_82293_);
            }
            case NORTH: {
                return new AABB(box.f_82288_, box.f_82289_, coordinate, box.f_82291_, box.f_82292_, box.f_82293_);
            }
            case SOUTH: {
                return new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, coordinate);
            }
            case WEST: {
                return new AABB(coordinate, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
            }
            case EAST: {
                return new AABB(box.f_82288_, box.f_82289_, box.f_82290_, coordinate, box.f_82292_, box.f_82293_);
            }
        }
        throw new RuntimeException();
    }

    public static <A, B> Tuple<B, A> swaped(Tuple<A, B> p) {
        return new Tuple(p.m_14419_(), p.m_14418_());
    }

    public static <T> T uniqueOfThree(T a, T b, T c) {
        if (a.equals(b)) {
            return c;
        }
        if (b.equals(c)) {
            return a;
        }
        assert (a.equals(c));
        return b;
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
    }

    public static Tuple<Direction.Axis, Direction.Axis> getAnotherTwoAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new Tuple((Object)Direction.Axis.Y, (Object)Direction.Axis.Z);
            }
            case Y: {
                return new Tuple((Object)Direction.Axis.Z, (Object)Direction.Axis.X);
            }
            case Z: {
                return new Tuple((Object)Direction.Axis.X, (Object)Direction.Axis.Y);
            }
        }
        throw new IllegalArgumentException();
    }

    public static BlockPos scale(Vec3i v, int m) {
        return new BlockPos(v.m_123341_() * m, v.m_123342_() * m, v.m_123343_() * m);
    }

    public static BlockPos divide(Vec3i v, int d) {
        return new BlockPos(v.m_123341_() / d, v.m_123342_() / d, v.m_123343_() / d);
    }

    public static BlockPos floorDiv(Vec3i v, int d) {
        return new BlockPos(Math.floorDiv(v.m_123341_(), d), Math.floorDiv(v.m_123342_(), d), Math.floorDiv(v.m_123343_(), d));
    }

    public static Direction[] getAnotherFourDirections(Direction.Axis axisOfNormal) {
        Tuple<Direction.Axis, Direction.Axis> anotherTwoAxis = Helper.getAnotherTwoAxis(axisOfNormal);
        return new Direction[]{Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.m_14418_())), Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.m_14419_())), Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.m_14418_())), Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.m_14419_()))};
    }

    public static Tuple<Direction, Direction> getPerpendicularDirections(Direction facing) {
        Tuple axises = Helper.getAnotherTwoAxis(facing.m_122434_());
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            axises = new Tuple((Object)((Direction.Axis)axises.m_14419_()), (Object)((Direction.Axis)axises.m_14418_()));
        }
        return new Tuple((Object)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.m_14418_())), (Object)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.m_14419_())));
    }

    public static Vec3 getBoxSize(AABB box) {
        return new Vec3(box.m_82362_(), box.m_82376_(), box.m_82385_());
    }

    public static AABB getBoxSurfaceInversed(AABB box, Direction direction) {
        double size = Helper.getCoordinate(Helper.getBoxSize(box), direction.m_122434_());
        Vec3 shrinkVec = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(size);
        return box.m_82310_(shrinkVec.f_82479_, shrinkVec.f_82480_, shrinkVec.f_82481_);
    }

    public static AABB getBoxSurface(AABB box, Direction direction) {
        return Helper.getBoxSurfaceInversed(box, direction.m_122424_());
    }

    public static IntBox expandRectangle(BlockPos startingPos, Predicate<BlockPos> blockPosPredicate, Direction.Axis axis) {
        IntBox wallArea = new IntBox(startingPos, startingPos);
        for (Direction direction : Helper.getAnotherFourDirections(axis)) {
            wallArea = Helper.expandArea(wallArea, blockPosPredicate, direction);
        }
        return wallArea;
    }

    public static IntBox expandBoxArea(BlockPos startingPos, Predicate<BlockPos> blockPosPredicate) {
        IntBox box = new IntBox(startingPos, startingPos);
        for (Direction direction : Direction.values()) {
            box = Helper.expandArea(box, blockPosPredicate, direction);
        }
        return box;
    }

    public static int getChebyshevDistance(int x1, int z1, int x2, int z2) {
        return Math.max(Math.abs(x1 - x2), Math.abs(z1 - z2));
    }

    public static AABB getBoxByBottomPosAndSize(Vec3 boxBottomCenter, Vec3 viewBoxSize) {
        return new AABB(boxBottomCenter.m_82492_(viewBoxSize.f_82479_ / 2.0, 0.0, viewBoxSize.f_82481_ / 2.0), boxBottomCenter.m_82520_(viewBoxSize.f_82479_ / 2.0, viewBoxSize.f_82480_, viewBoxSize.f_82481_ / 2.0));
    }

    public static Vec3 getBoxBottomCenter(AABB box) {
        return new Vec3((box.f_82291_ + box.f_82288_) / 2.0, box.f_82289_, (box.f_82293_ + box.f_82290_) / 2.0);
    }

    public static double getDistanceToRectangle(double pointX, double pointY, double rectAX, double rectAY, double rectBX, double rectBY) {
        assert (rectAX <= rectBX);
        assert (rectAY <= rectBY);
        double wx1 = rectAX - pointX;
        double wx2 = rectBX - pointX;
        double dx = wx1 * wx2 < 0.0 ? 0.0 : Math.min(Math.abs(wx1), Math.abs(wx2));
        double wy1 = rectAY - pointY;
        double wy2 = rectBY - pointY;
        double dy = wy1 * wy2 < 0.0 ? 0.0 : Math.min(Math.abs(wy1), Math.abs(wy2));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T> void swapListElement(List<T> entries, int i1, int i2) {
        T temp = entries.get(i1);
        entries.set(i1, entries.get(i2));
        entries.set(i2, temp);
    }

    public static double crossProduct2D(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    @Nullable
    public static <T> T getLastSatisfying(Stream<T> stream, Predicate<T> predicate) {
        T last = null;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (predicate.test(obj)) {
                last = obj;
                continue;
            }
            return last;
        }
        return last;
    }

    public static void doNotEatExceptionMessage(Runnable func) {
        try {
            func.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static <T> String myToString(Stream<T> stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stream.forEach(obj -> {
            stringBuilder.append(obj.toString());
            stringBuilder.append('\n');
        });
        return stringBuilder.toString();
    }

    public static <A, B> Stream<Tuple<A, B>> composeTwoStreamsWithEqualLength(Stream<A> a, Stream<B> b) {
        final Iterator aIterator = a.iterator();
        final Iterator bIterator = b.iterator();
        Iterator iterator = new Iterator<Tuple<A, B>>(){

            @Override
            public boolean hasNext() {
                assert (aIterator.hasNext() == bIterator.hasNext());
                return aIterator.hasNext();
            }

            @Override
            public Tuple<A, B> next() {
                return new Tuple(aIterator.next(), bIterator.next());
            }
        };
        return Streams.stream((Iterator)iterator);
    }

    public static void log(Object str) {
        logger.info(str);
    }

    public static void err(Object str) {
        logger.error(str);
    }

    public static void dbg(Object str) {
        logger.debug(str);
    }

    public static Vec3[] eightVerticesOf(AABB box) {
        return new Vec3[]{new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), new Vec3(box.f_82288_, box.f_82292_, box.f_82290_), new Vec3(box.f_82288_, box.f_82292_, box.f_82293_), new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), new Vec3(box.f_82291_, box.f_82292_, box.f_82290_), new Vec3(box.f_82291_, box.f_82292_, box.f_82293_)};
    }

    public static void putVec3d(CompoundTag compoundTag, String name, Vec3 vec3d) {
        compoundTag.m_128347_(name + "X", vec3d.f_82479_);
        compoundTag.m_128347_(name + "Y", vec3d.f_82480_);
        compoundTag.m_128347_(name + "Z", vec3d.f_82481_);
    }

    public static Vec3 getVec3d(CompoundTag compoundTag, String name) {
        return new Vec3(compoundTag.m_128459_(name + "X"), compoundTag.m_128459_(name + "Y"), compoundTag.m_128459_(name + "Z"));
    }

    @Nullable
    public static Vec3 getVec3dOptional(CompoundTag compoundTag, String name) {
        if (compoundTag.m_128441_(name + "X")) {
            return Helper.getVec3d(compoundTag, name);
        }
        return null;
    }

    public static void putVec3i(CompoundTag compoundTag, String name, Vec3i vec3i) {
        compoundTag.m_128405_(name + "X", vec3i.m_123341_());
        compoundTag.m_128405_(name + "Y", vec3i.m_123342_());
        compoundTag.m_128405_(name + "Z", vec3i.m_123343_());
    }

    public static BlockPos getVec3i(CompoundTag compoundTag, String name) {
        return new BlockPos(compoundTag.m_128451_(name + "X"), compoundTag.m_128451_(name + "Y"), compoundTag.m_128451_(name + "Z"));
    }

    public static void putQuaternion(CompoundTag compoundTag, String name, @Nullable DQuaternion quaternion) {
        if (quaternion != null) {
            compoundTag.m_128347_(name + "X", quaternion.getX());
            compoundTag.m_128347_(name + "Y", quaternion.getY());
            compoundTag.m_128347_(name + "Z", quaternion.getZ());
            compoundTag.m_128347_(name + "W", quaternion.getW());
        }
    }

    @Nullable
    public static DQuaternion getQuaternion(CompoundTag compoundTag, String name) {
        if (compoundTag.m_128441_(name + "X")) {
            return new DQuaternion(compoundTag.m_128459_(name + "X"), compoundTag.m_128459_(name + "Y"), compoundTag.m_128459_(name + "Z"), compoundTag.m_128459_(name + "W"));
        }
        return null;
    }

    public static ListTag getCompoundList(CompoundTag tag, String name) {
        return tag.m_128437_(name, 10);
    }

    public static <X> ArrayList<X> listTagToList(ListTag listTag, Function<CompoundTag, X> deserializer) {
        return Helper.listTagDeserialize(listTag, deserializer, CompoundTag.class);
    }

    public static <X> ListTag listToListTag(List<X> list, Function<X, CompoundTag> serializer) {
        return Helper.listTagSerialize(list, serializer);
    }

    public static <X, TT extends Tag> ArrayList<X> listTagDeserialize(ListTag listTag, Function<TT, X> deserializer, Class<TT> tagClass) {
        ArrayList result = new ArrayList();
        listTag.forEach(tag -> {
            if (tag.getClass() == tagClass) {
                Object obj = deserializer.apply(tag);
                if (obj != null) {
                    result.add(obj);
                }
            } else {
                logger.error("Unexpected tag class: {}", tag.getClass(), (Object)new Throwable());
            }
        });
        return result;
    }

    public static <X, TT extends Tag> ListTag listTagSerialize(List<X> list, Function<X, TT> serializer) {
        ListTag listTag = new ListTag();
        for (X x : list) {
            listTag.add((Object)((Tag)serializer.apply(x)));
        }
        return listTag;
    }

    public static <T> void compareOldAndNew(Set<T> oldSet, Set<T> newSet, Consumer<T> forRemoved, Consumer<T> forAdded) {
        oldSet.stream().filter(e -> !newSet.contains(e)).forEach(forRemoved);
        newSet.stream().filter(e -> !oldSet.contains(e)).forEach(forAdded);
    }

    public static long secondToNano(double second) {
        return (long)(second * 1.0E9);
    }

    public static double nanoToSecond(long nano) {
        return (double)nano / 1.0E9;
    }

    public static IntBox expandArea(IntBox originalArea, Predicate<BlockPos> predicate, Direction direction) {
        IntBox currentBox = originalArea;
        for (int i = 1; i < 42; ++i) {
            IntBox expanded = currentBox.getExpanded(direction, 1);
            if (!expanded.getSurfaceLayer(direction).stream().allMatch(predicate)) {
                return currentBox;
            }
            currentBox = expanded;
        }
        return currentBox;
    }

    public static <A, B> B reduce(B start, Stream<A> stream, BiFunction<B, A, B> func) {
        return stream.reduce(start, func, (a, b) -> {
            throw new IllegalStateException("combiner should only be used in parallel");
        });
    }

    public static <T> T noError(Callable<T> func) {
        try {
            return func.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void removeIf(ObjectList<T> list, Predicate<T> predicate) {
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (predicate.test(curr)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap(Stream<T> stream, final BiFunction<T, T, S> function) {
        final Iterator iterator = stream.iterator();
        return Streams.stream((Iterator)new Iterator<S>(){
            private boolean isBuffered = false;
            private T buffer;

            private void fillBuffer() {
                if (!this.isBuffered) {
                    assert (iterator.hasNext());
                    this.isBuffered = true;
                    this.buffer = iterator.next();
                }
            }

            private T takeBuffer() {
                assert (this.isBuffered);
                this.isBuffered = false;
                return this.buffer;
            }

            @Override
            public boolean hasNext() {
                if (!iterator.hasNext()) {
                    return false;
                }
                this.fillBuffer();
                return iterator.hasNext();
            }

            @Override
            public S next() {
                this.fillBuffer();
                Object a = this.takeBuffer();
                this.fillBuffer();
                return function.apply(a, this.buffer);
            }
        });
    }

    public static <A, B> Stream<B> mapReduce(Stream<A> stream, BiFunction<B, A, B> func, SimpleBox<B> startValue) {
        return stream.map(a -> {
            startValue.obj = func.apply(startValue.obj, a);
            return startValue.obj;
        });
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap1(Stream<T> stream, BiFunction<T, T, S> function) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        Object firstValue = iterator.next();
        Stream newStream = Streams.stream(iterator);
        return Helper.mapReduce(newStream, (lastPair, curr) -> new Tuple(curr, function.apply(lastPair.m_14418_(), curr)), new SimpleBox<Tuple>(new Tuple(firstValue, null))).map(pair -> pair.m_14419_());
    }

    public static <T> T makeIntoExpression(T t, Consumer<T> func) {
        func.accept(t);
        return t;
    }

    public static void putUuid(CompoundTag tag, String key, UUID uuid) {
        tag.m_128356_(key + "Most", uuid.getMostSignificantBits());
        tag.m_128356_(key + "Least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getUuid(CompoundTag tag, String key) {
        String key1 = key + "Most";
        if (!tag.m_128441_(key1)) {
            return null;
        }
        return new UUID(tag.m_128454_(key1), tag.m_128454_(key + "Least"));
    }

    public static Vec3 getFlippedVec(Vec3 vec, Vec3 flippingAxis) {
        Vec3 component = Helper.getProjection(vec, flippingAxis);
        return vec.m_82546_(component).m_82490_(-1.0).m_82549_(component);
    }

    public static Vec3 getProjection(Vec3 vec, Vec3 direction) {
        return direction.m_82490_(vec.m_82526_(direction));
    }

    public static Direction getFacingExcludingAxis(Vec3 vec, Direction.Axis axis) {
        return Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != axis).max(Comparator.comparingDouble(dir -> vec.f_82479_ * (double)dir.m_122429_() + vec.f_82480_ * (double)dir.m_122430_() + vec.f_82481_ * (double)dir.m_122431_())).orElse(null);
    }

    public static <T> Supplier<T> cached(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T cache = null;

            @Override
            public T get() {
                if (this.cache == null) {
                    this.cache = supplier.get();
                }
                Validate.notNull(this.cache);
                return this.cache;
            }
        };
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            T ele = list.get(i);
            if (!predicate.test(ele)) continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitStringByLen(String str, int len) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i * len < str.length()) {
            result.add(str.substring(i * len, Math.min(str.length(), (i + 1) * len)));
            ++i;
        }
        return result;
    }

    public static AABB transformBox(AABB box, Function<Vec3, Vec3> function) {
        List result = Arrays.stream(Helper.eightVerticesOf(box)).map(function).collect(Collectors.toList());
        return new AABB(result.stream().mapToDouble(b -> b.f_82479_).min().getAsDouble(), result.stream().mapToDouble(b -> b.f_82480_).min().getAsDouble(), result.stream().mapToDouble(b -> b.f_82481_).min().getAsDouble(), result.stream().mapToDouble(b -> b.f_82479_).max().getAsDouble(), result.stream().mapToDouble(b -> b.f_82480_).max().getAsDouble(), result.stream().mapToDouble(b -> b.f_82481_).max().getAsDouble());
    }

    private static double getDistanceToRange(double start, double end, double pos) {
        Validate.isTrue((end >= start ? 1 : 0) != 0);
        if (pos >= start) {
            if (pos <= end) {
                return 0.0;
            }
            return pos - end;
        }
        return start - pos;
    }

    public static double getDistanceToBox(AABB box, Vec3 point) {
        double dx = Helper.getDistanceToRange(box.f_82288_, box.f_82291_, point.f_82479_);
        double dy = Helper.getDistanceToRange(box.f_82289_, box.f_82292_, point.f_82480_);
        double dz = Helper.getDistanceToRange(box.f_82290_, box.f_82293_, point.f_82481_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static <T> T firstOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(0);
    }

    public static <T> T lastOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(list.size() - 1);
    }

    @Nullable
    public static <T> T combineNullable(@Nullable T a, @Nullable T b, BiFunction<T, T, T> combiner) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return combiner.apply(a, b);
    }

    public static <T> T arrayListComputeIfAbsent(List<T> arrayList, int index, Supplier<T> supplier) {
        T value;
        if (arrayList.size() <= index) {
            while (arrayList.size() <= index) {
                arrayList.add(null);
            }
        }
        if ((value = arrayList.get(index)) == null) {
            value = supplier.get();
            arrayList.set(index, value);
        }
        return value;
    }

    public static <T> void arrayListKeyValueForeach(ArrayList<T> arrayList, IntObjectConsumer<T> func) {
        for (int i = 0; i < arrayList.size(); ++i) {
            T value = arrayList.get(i);
            if (value == null) continue;
            func.consume(i, value);
        }
    }

    public static Object reflectionInvoke(Object target, String methodName) {
        return Helper.noError(() -> {
            Method method = target.getClass().getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(target, new Object[0]);
        });
    }

    public static Vec3 interpolatePos(Vec3 from, Vec3 to, double progress) {
        return from.m_165921_(to, progress);
    }

    public static <T> T getFirstNullable(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T minBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) <= 0) {
            return a;
        }
        return b;
    }

    public static <T> T maxBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) >= 0) {
            return a;
        }
        return b;
    }

    public static boolean boxContains(AABB outer, AABB inner) {
        return outer.m_82393_(inner.f_82288_, inner.f_82289_, inner.f_82290_) && outer.m_82393_(inner.f_82291_, inner.f_82292_, inner.f_82293_);
    }

    public static <A, B> List<B> mappedListView(final List<A> originalList, final Function<A, B> mapping) {
        return new AbstractList<B>(){

            @Override
            public B get(int index) {
                return mapping.apply(originalList.get(index));
            }

            @Override
            public int size() {
                return originalList.size();
            }
        };
    }

    public static OptionalDouble parseDouble(String str) {
        try {
            return OptionalDouble.of(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    public static OptionalInt parseInt(String str) {
        try {
            return OptionalInt.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static List<Vec3> deduplicateWithPrecision(Collection<Vec3> points, int precision) {
        HashSet<LongBlockPos> set = new HashSet<LongBlockPos>();
        for (Vec3 point : points) {
            set.add(new LongBlockPos(Math.round(point.f_82479_ * (double)precision), Math.round(point.f_82480_ * (double)precision), Math.round(point.f_82481_ * (double)precision)));
        }
        return set.stream().map(blockPos -> new Vec3((double)blockPos.x() / (double)precision, (double)blockPos.y() / (double)precision, (double)blockPos.z() / (double)precision)).collect(Collectors.toList());
    }

    public static double getDistanceFromPointToLine(Vec3 point, Vec3 lineOrigin, Vec3 lineDirection) {
        Vec3 lineDirectionNormalized = lineDirection.m_82541_();
        Vec3 pointToLineOrigin = lineOrigin.m_82546_(point);
        Vec3 pointToLineOriginProjected = pointToLineOrigin.m_82546_(lineDirectionNormalized.m_82490_(pointToLineOrigin.m_82526_(lineDirectionNormalized)));
        return pointToLineOriginProjected.m_82553_();
    }

    public static void traverseBoxEdge(BoxEdgeConsumer consumer) {
        int dz;
        int dx;
        for (dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                consumer.consume(dx, dy, 0, dx, dy, 1);
            }
        }
        for (dx = 0; dx <= 1; ++dx) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(dx, 0, dz, dx, 1, dz);
            }
        }
        for (int dy = 0; dy <= 1; ++dy) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(0, dy, dz, 1, dy, dz);
            }
        }
    }

    public static List<Vec3> verticesAndEdgeMidpoints(AABB box) {
        ArrayList<Vec3> result = new ArrayList<Vec3>();
        for (int xi = 0; xi <= 2; ++xi) {
            for (int yi = 0; yi <= 2; ++yi) {
                for (int zi = 0; zi <= 2; ++zi) {
                    if (xi == 1 && yi == 1 && zi == 1) continue;
                    double x = box.f_82288_ + (double)xi / 2.0 * (box.f_82291_ - box.f_82288_);
                    double y = box.f_82289_ + (double)yi / 2.0 * (box.f_82292_ - box.f_82289_);
                    double z = box.f_82290_ + (double)zi / 2.0 * (box.f_82293_ - box.f_82290_);
                    result.add(new Vec3(x, y, z));
                }
            }
        }
        return result;
    }

    public static Vec3 alignToBoxSurface(AABB box, Vec3 pos, int gridCount) {
        double x = pos.f_82479_;
        double y = pos.f_82480_;
        double z = pos.f_82481_;
        if (x < box.f_82288_) {
            x = box.f_82288_;
        }
        if (y < box.f_82289_) {
            y = box.f_82289_;
        }
        if (z < box.f_82290_) {
            z = box.f_82290_;
        }
        if (x > box.f_82291_) {
            x = box.f_82291_;
        }
        if (y > box.f_82292_) {
            y = box.f_82292_;
        }
        if (z > box.f_82293_) {
            z = box.f_82293_;
        }
        double boxSizeX = box.m_82362_();
        double boxSizeY = box.m_82376_();
        double boxSizeZ = box.m_82385_();
        double xOffset = x - box.f_82288_;
        double yOffset = y - box.f_82289_;
        double zOffset = z - box.f_82290_;
        xOffset = (double)Math.round(xOffset * (double)gridCount) / (double)gridCount;
        yOffset = (double)Math.round(yOffset * (double)gridCount) / (double)gridCount;
        zOffset = (double)Math.round(zOffset * (double)gridCount) / (double)gridCount;
        double distanceToXMin = xOffset;
        double distanceToXMax = boxSizeX - xOffset;
        double distanceToYMin = yOffset;
        double distanceToYMax = boxSizeY - yOffset;
        double distanceToZMin = zOffset;
        double distanceToZMax = boxSizeZ - zOffset;
        double minDistance = Math.min(Math.min(distanceToXMin, distanceToXMax), Math.min(Math.min(distanceToYMin, distanceToYMax), Math.min(distanceToZMin, distanceToZMax)));
        if (minDistance == distanceToXMin) {
            xOffset = 0.0;
        } else if (minDistance == distanceToXMax) {
            xOffset = boxSizeX;
        } else if (minDistance == distanceToYMin) {
            yOffset = 0.0;
        } else if (minDistance == distanceToYMax) {
            yOffset = boxSizeY;
        } else if (minDistance == distanceToZMin) {
            zOffset = 0.0;
        } else if (minDistance == distanceToZMax) {
            zOffset = boxSizeZ;
        }
        return new Vec3(box.f_82288_ + xOffset, box.f_82289_ + yOffset, box.f_82290_ + zOffset);
    }

    public static int compactArrayStorage(int arraySize, IntPredicate isElementValid, SwappingFunc swap) {
        int validElementCount = 0;
        int invalidElementCount = 0;
        block0: while (validElementCount + invalidElementCount < arraySize) {
            if (isElementValid.test(validElementCount)) {
                ++validElementCount;
                continue;
            }
            int invalidElementIndex = arraySize - ++invalidElementCount;
            while (invalidElementIndex > validElementCount) {
                if (isElementValid.test(invalidElementIndex)) {
                    swap.swap(invalidElementIndex, validElementCount);
                    ++validElementCount;
                    continue block0;
                }
                invalidElementIndex = arraySize - ++invalidElementCount;
            }
        }
        return validElementCount;
    }

    public static <T> Stream<T> listReverseStream(final List<T> list) {
        return Streams.stream((Iterator)new Iterator<T>(){
            int index;
            {
                this.index = list.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public T next() {
                int i = this.index--;
                return list.get(i);
            }
        });
    }

    public static class SimpleBox<T> {
        public T obj;

        public SimpleBox(T obj) {
            this.obj = obj;
        }
    }

    public static interface IntObjectConsumer<T> {
        public void consume(int var1, T var2);
    }

    public static interface BoxEdgeConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    @FunctionalInterface
    public static interface SwappingFunc {
        public void swap(int var1, int var2);
    }
}

